@extends('layouts.app')

@section('title', 'Patient Dashboard')

@section('content')
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
    <h1 class="text-3xl font-bold text-gray-800 mb-6">My Dashboard</h1>

    @if($patient)
    <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-8">
        <div class="bg-white rounded-lg shadow p-6">
            <div class="flex items-center">
                <div class="p-3 bg-blue-100 rounded-full">
                    <i class="fas fa-prescription text-blue-600 text-2xl"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm text-gray-600">Total Prescriptions</p>
                    <p class="text-2xl font-bold">{{ $prescriptions->count() }}</p>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow p-6">
            <div class="flex items-center">
                <div class="p-3 bg-green-100 rounded-full">
                    <i class="fas fa-calendar text-green-600 text-2xl"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm text-gray-600">Total Appointments</p>
                    <p class="text-2xl font-bold">{{ $appointments->count() }}</p>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow p-6">
            <div class="flex items-center">
                <div class="p-3 bg-purple-100 rounded-full">
                    <i class="fas fa-user text-purple-600 text-2xl"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm text-gray-600">Patient ID</p>
                    <p class="text-2xl font-bold">{{ $patient->patient_id }}</p>
                </div>
            </div>
        </div>
    </div>

    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
        <div class="bg-white rounded-lg shadow p-6">
            <h2 class="text-xl font-bold mb-4">Recent Prescriptions</h2>
            @if($prescriptions->count() > 0)
                <div class="space-y-4">
                    @foreach($prescriptions->take(5) as $prescription)
                    <div class="border-b pb-4">
                        <div class="flex justify-between items-start">
                            <div>
                                <p class="font-semibold">#{{ $prescription->prescription_number }}</p>
                                <p class="text-sm text-gray-600">Dr. {{ $prescription->doctor->full_name }}</p>
                                <p class="text-xs text-gray-500">{{ $prescription->created_at->format('M d, Y') }}</p>
                            </div>
                            <a href="{{ route('prescriptions.show', $prescription->id) }}" class="text-blue-600 hover:text-blue-800">
                                View
                            </a>
                        </div>
                    </div>
                    @endforeach
                </div>
                <div class="mt-4">
                    <a href="{{ route('patient.prescriptions') }}" class="text-blue-600 hover:text-blue-800">View All Prescriptions</a>
                </div>
            @else
                <p class="text-gray-500">No prescriptions yet.</p>
            @endif
        </div>

        <div class="bg-white rounded-lg shadow p-6">
            <h2 class="text-xl font-bold mb-4">Recent Appointments</h2>
            @if($appointments->count() > 0)
                <div class="space-y-4">
                    @foreach($appointments->take(5) as $appointment)
                    <div class="border-b pb-4">
                        <div class="flex justify-between items-start">
                            <div>
                                <p class="font-semibold">{{ $appointment->consultation_type }}</p>
                                <p class="text-sm text-gray-600">{{ $appointment->branch->name }}</p>
                                <p class="text-xs text-gray-500">{{ $appointment->appointment_date->format('M d, Y H:i') }}</p>
                            </div>
                            <span class="px-2 py-1 text-xs rounded-full bg-{{ $appointment->status === 'completed' ? 'green' : 'yellow' }}-100 text-{{ $appointment->status === 'completed' ? 'green' : 'yellow' }}-800">
                                {{ ucfirst($appointment->status) }}
                            </span>
                        </div>
                    </div>
                    @endforeach
                </div>
                <div class="mt-4">
                    <a href="{{ route('patient.appointments') }}" class="text-blue-600 hover:text-blue-800">View All Appointments</a>
                </div>
            @else
                <p class="text-gray-500">No appointments yet.</p>
            @endif
        </div>
    </div>
    @else
    <div class="bg-yellow-100 border border-yellow-400 text-yellow-700 px-4 py-3 rounded">
        <p>Patient record not found. Please contact the pharmacy to link your account.</p>
    </div>
    @endif
</div>
@endsection

